#define anti_origin nil \

/*10:*/
#line 19 "basics.w"

/*19:*/
#line 334 "basics.w"


#include "chull.h"

class Simplex{
friend class Triangulation;
private:
int sim_nr;
list_item this_item;
array<list_item>vertices;

array<Simplex*>neighbors;
array<int>opposite_vertices;

array<hyperplane>facets;
array<int>valid_equations;


bool visited;

list<list_item>points;

Simplex(int dmax);

~Simplex(){};

LEDA_MEMORY(Simplex);
};

/*:19*//*20:*/
#line 367 "basics.w"


Simplex::Simplex(int dmax):vertices(0,dmax),
neighbors(0,dmax),
opposite_vertices(0,dmax),
facets(0,dmax),
valid_equations(0,dmax)
{static int lfdnr= 0;

sim_nr= lfdnr++;
for(int i= 0;i<=dmax;i++){
neighbors[i]= nil;
valid_equations[i]= -1;
}
visited= false;
}

#line 1 "insert.w"
/*:20*/
#line 20 "basics.w"

/*16:*/
#line 191 "basics.w"

int Triangulation::created_simplices()
{Simplex Dummy(2);
static dummys_created= 0;

dummys_created++;
return Dummy.sim_nr-dummys_created;
}

/*:16*//*17:*/
#line 203 "basics.w"

Triangulation::Triangulation(int d,search_method m):
order_nr(-1),simplex(nil),position(nil)
{
co_nr= 0;
dcur= -1;
dmax= d;
searched_simplices= 0;
origin_simplex= nil;
method= m;
inner_simplex= nil;
}

Triangulation::Triangulation(Triangulation&T):
order_nr(-1),simplex(nil),position(nil)
{
d_rat_point v;

co_nr= 0;
dcur= -1;
dmax= T.dmax;
searched_simplices= 0;
origin_simplex= nil;
method= T.method;
inner_simplex= nil;
forall(v,T.coordinates)
insert(v);
}

/*:17*//*18:*/
#line 235 "basics.w"

Triangulation::~Triangulation()
{Simplex*S;
forall(S,all_simplices)
delete(S);
}

/*:18*//*21:*/
#line 11 "insert.w"

void Triangulation::insert(const d_rat_point&x)
{
dic_item dic_x;

if(x.dim()!=dmax)
error_handler(99,"chull: incorrect dimension");

list_item item_x= coordinates.append(x);
order_nr[item_x]= co_nr++;


if((dic_x= co_index.lookup(x))==nil)
{dic_x= co_index.insert(x,new list<list_item>);}

co_index.inf(dic_x)->append(item_x);


if(dcur==-1){
/*22:*/
#line 51 "insert.w"

Simplex*outer_simplex;

dcur= 0;
origin_simplex= new Simplex(dmax);
origin_simplex->this_item= all_simplices.append(origin_simplex);
outer_simplex= new Simplex(dmax);
outer_simplex->this_item= all_simplices.append(outer_simplex);



origin_simplex->vertices[0]= item_x;
origin_simplex->neighbors[0]= outer_simplex;
origin_simplex->opposite_vertices[0]= 0;

outer_simplex->vertices[0]= anti_origin;
outer_simplex->neighbors[0]= origin_simplex;
outer_simplex->opposite_vertices[0]= 0;

quasi_center= x;

simplex[item_x]= origin_simplex;


/*:22*/
#line 30 "insert.w"

}
else if((dcur<dmax)&&is_dimension_jump(x)){
/*40:*/
#line 23 "dimension_jump.w"

dcur++;
quasi_center+= x;
simplex[item_x]= origin_simplex;
dimension_jump(origin_simplex,item_x);
clear_visited_marks(origin_simplex);





/*:40*/
#line 33 "insert.w"

}
else{
/*23:*/
#line 92 "insert.w"



if(dcur>0){
find_visible_facets(x);
if(!visible_simplices.empty()){
list<Simplex*>NewSimplices;

Simplex*S;
forall(S,visible_simplices)
{



S->vertices[0]= item_x;
simplex[item_x]= S;
/*24:*/
#line 208 "insert.w"

for(int k= 1;k<=dcur;k++){

if(sees_facet(S->neighbors[k],0,x)<=0){

Simplex*T= new Simplex(dmax);
T->this_item= all_simplices.append(T);
NewSimplices.append(T);



int ii;
for(ii= 0;ii<=dcur;ii++)
T->vertices[ii]= S->vertices[ii];
T->vertices[k]= S->vertices[dcur];
T->vertices[dcur]= item_x;
T->vertices[0]= anti_origin;



T->neighbors[dcur]= S->neighbors[k];
T->opposite_vertices[dcur]= S->opposite_vertices[k];
T->neighbors[0]= S;
T->opposite_vertices[0]= k;

S->neighbors[k]->neighbors[S->opposite_vertices[k]]= T;
S->neighbors[k]->opposite_vertices[S->opposite_vertices[k]]= dcur;
S->neighbors[k]= T;
S->opposite_vertices[k]= 0;
}
}


/*:24*/
#line 108 "insert.w"

}
visible_simplices.clear();
/*25:*/
#line 331 "insert.w"

Simplex*Af;
forall(Af,NewSimplices){
for(int k= 1;k<dcur;k++){

Simplex*T= Af->neighbors[0];
int y1;
for(y1= 0;T->vertices[y1]!=Af->vertices[k];y1++);

int y2= Af->opposite_vertices[0];
while(T->vertices[0]==item_x){

int new_y1;
for(new_y1= 0;
T->neighbors[y1]->vertices[new_y1]!=T->vertices[y2];
new_y1++);

y2= T->opposite_vertices[y1];
T= T->neighbors[y1];
y1= new_y1;
}
Af->neighbors[k]= T;
Af->opposite_vertices[k]= y1;
}
}


#line 1 "search_methods.w"
/*:25*/
#line 111 "insert.w"

}
else
{
position[item_x]= inner_simplex->points.append(item_x);
simplex[item_x]= inner_simplex;
inner_simplex= nil;
}
}
else{
position[item_x]= origin_simplex->points.append(item_x);
simplex[item_x]= origin_simplex;
}


/*:23*/
#line 36 "insert.w"

}
}

/*:21*//*27:*/
#line 52 "search_methods.w"

void Triangulation::find_visible_facets(const d_rat_point&x)
{
Simplex*last_simplex;


switch(method){
case VISIBILITY:
visibility_search(origin_simplex,x);

clear_visited_marks(origin_simplex);
if((visible_simplices.empty())&&(inner_simplex==nil))
inner_simplex= origin_simplex;
break;
case MODIFIED_VISIBILITY:
last_simplex= search_to_outside(origin_simplex,x);
if(last_simplex!=nil)
collect_visible_simplices(last_simplex,x);

else
if(inner_simplex==nil)
inner_simplex= origin_simplex;
clear_visited_marks(origin_simplex);
break;
case SEGMENT_WALK:
default:
last_simplex= segment_walk(x);
if(last_simplex->vertices[0]==anti_origin){
collect_visible_simplices(last_simplex,x);

clear_visited_marks(last_simplex);
}
else
inner_simplex= last_simplex;
break;
}
}

/*:27*//*28:*/
#line 102 "search_methods.w"

void Triangulation::visibility_search(Simplex*S,
const d_rat_point&x)
{
searched_simplices++;
S->visited= true;
for(int i= 0;i<=dcur;i++){
Simplex*T= S->neighbors[i];
if(!T->visited){


if(sees_facet(T,0,x)>0){


if(T->vertices[0]==anti_origin)

visible_simplices.push(T);

else

{
bool in= true;
int j;
for(j= 1;j<=dcur;j++)
if(sees_facet(T,j,x)<0)
in= false;
if(in)
inner_simplex= T;
}
visibility_search(T,x);

}
}
}
}


/*:28*//*29:*/
#line 151 "search_methods.w"

Simplex*Triangulation::search_to_outside(Simplex*S,
const d_rat_point&x)
{
searched_simplices++;
S->visited= true;
for(int i= 0;i<=dcur;i++){
Simplex*T= S->neighbors[i];
if(!T->visited)


if(sees_facet(T,0,x)>0){


if(T->vertices[0]==anti_origin)

return T;
else
{
bool in= true;
int j;

for(j= 1;j<=dcur;j++)
if(sees_facet(T,j,x)<0)
in= false;
if(in)
inner_simplex= T;
}
Simplex*result= search_to_outside(T,x);
if(result!=nil)
return result;
}
}
return nil;
}

/*:29*//*30:*/
#line 190 "search_methods.w"

void Triangulation::collect_visible_simplices(Simplex*S,
const d_rat_point&x)
{
searched_simplices++;
S->visited= true;
visible_simplices.push(S);

for(int i= 0;i<=dcur;i++){
Simplex*T= S->neighbors[i];
if(!T->visited&&T->vertices[0]==anti_origin)


if(sees_facet(T,0,x)>0)

collect_visible_simplices(T,x);
}
}


/*:30*//*31:*/
#line 216 "search_methods.w"

void Triangulation::clear_visited_marks(Simplex*S)
{
S->visited= false;
for(int i= 0;i<=dcur;i++)
if(S->neighbors[i]->visited)
clear_visited_marks(S->neighbors[i]);

}



/*:31*//*32:*/
#line 356 "search_methods.w"

Simplex*Triangulation::segment_walk(const d_rat_point&x)
{Simplex*S= origin_simplex;
bool x_in_S= false;
int in= -1;
int i;
d_rat_point O= quasi_center/(dcur+1);
array<integer>fx(0,dcur);
array<integer>fO(0,dcur);

while(!x_in_S){
searched_simplices++;
/*33:*/
#line 381 "search_methods.w"

{
x_in_S= true;
if(S->vertices[0]!=anti_origin)
{
for(i= 0;i<=dcur;i++){
compute_plane(S,i);

fx[i]= S->facets[i].value_at(x);
fO[i]= S->facets[i].value_at(O);
if(sign(fx[i])<0)
x_in_S= false;
}
}
}

/*:33*/
#line 368 "search_methods.w"

if(!x_in_S){
/*35:*/
#line 431 "search_methods.w"

int start= 0;
int out;



while((start==in)||
((in==-1)&&lambda_negative(S,O[0],x[0],fx[start],fO[start],start))||

((in!=-1)&&lambda_cmp(S,O[0],x[0],fx[start],fO[start],start,fx[in],fO[in],in)))

start++;

out= start++;
for(i= start;i<=dcur;i++)
{
if((i!=in)&&
(i!=out))
if((lambda_cmp(S,O[0],x[0],fx[i],fO[i],i,fx[out],fO[out],out))&&

((in!=-1)||(!lambda_negative(S,O[0],x[0],fx[i],fO[i],i)))&&

((in==-1)||(lambda_cmp(S,O[0],x[0],fx[in],fO[in],in,fx[i],fO[i],i))))

out= i;
}
in= S->opposite_vertices[out];
S= S->neighbors[out];

/*:35*/
#line 370 "search_methods.w"

}
}
return S;
}

/*:32*//*36:*/
#line 514 "search_methods.w"

bool Triangulation::lambda_cmp(Simplex*S,
const integer&Od,const integer&xd,
const integer&gx,const integer&gO,int g,
const integer&hx,const integer&hO,int h)
{
bool sigma;
int diffsign;
bool diffgr0;
int i;

/*37:*/
#line 555 "search_methods.w"

{
int lsign,rsign;
int i;


i= 1;
lsign= sign(Od*gx-xd*gO);
while(lsign==0)
lsign= -sign(S->facets[g][i++]);

i= 1;
rsign= sign(Od*hx-xd*hO);
while(rsign==0)
rsign= -sign(S->facets[h][i++]);
sigma= (lsign==rsign);
}

/*:37*/
#line 525 "search_methods.w"


i= 1;

diffsign= sign(gO*hx-hO*gx);

while(diffsign==0){


diffsign= sign(S->facets[g][i]*hx-S->facets[h][i]*gx);

i++;
}
diffgr0= (diffsign>0);
return!(diffgr0^sigma);
}

/*:36*//*38:*/
#line 584 "search_methods.w"

bool Triangulation::lambda_negative(Simplex*S,
const integer&Od,const integer&xd,
const integer&hx,const integer&hO,int h)
{
int zsign,nsign;
int i;


i= 1;
zsign= sign(hO);
while(zsign==0)
zsign= sign(S->facets[h][i++]);

i= 1;
nsign= sign(Od*hx-xd*hO);
while(nsign==0)
nsign= -sign(S->facets[h][i++]);
return(zsign==nsign);
}

#line 1 "dimension_jump.w"
/*:38*//*41:*/
#line 138 "dimension_jump.w"

void Triangulation::dimension_jump(Simplex*S,list_item x)
{
Simplex*S_new;

S->visited= true;
S->vertices[dcur]= x;
if(S->vertices[0]!=anti_origin){

/*42:*/
#line 199 "dimension_jump.w"

S_new= S->neighbors[dcur]= new Simplex(dmax);
S_new->this_item= all_simplices.append(S_new);
S->opposite_vertices[dcur]= 0;
S_new->vertices[0]= anti_origin;
for(int k= 1;k<=dcur;k++)
S_new->vertices[k]= S->vertices[k-1];


/*:42*/
#line 147 "dimension_jump.w"

}



for(int k= 0;k<=dcur-1;k++){
if(!S->neighbors[k]->visited)
dimension_jump(S->neighbors[k],x);
}
if(S->vertices[0]==anti_origin){
/*43:*/
#line 245 "dimension_jump.w"

S->neighbors[dcur]= S->neighbors[0]->neighbors[dcur];
S->opposite_vertices[dcur]= S->opposite_vertices[0]+1;




/*:43*/
#line 157 "dimension_jump.w"

}
else{
/*44:*/
#line 280 "dimension_jump.w"

for(int k= 0;k<dcur;k++){
if(S->neighbors[k]->vertices[0]==anti_origin){

S_new->neighbors[k+1]= S->neighbors[k];

S_new->opposite_vertices[k+1]= dcur;

}
else{

S_new->neighbors[k+1]= S->neighbors[k]->neighbors[dcur];

S_new->opposite_vertices[k+1]= S->opposite_vertices[k]+1;


}
}


S_new->neighbors[0]= S;
S_new->opposite_vertices[0]= dcur;



#line 1 "output_routines.w"
/*:44*/
#line 160 "dimension_jump.w"

}
}


/*:41*//*45:*/
#line 19 "output_routines.w"

void Triangulation::show(window&W)
{

Simplex*S;
forall(S,all_simplices){
for(int v= (S->vertices[0]==anti_origin?1:0);
v<=dcur;v++){
d_rat_point x= coordinates.contents(S->vertices[v]);
point a= convert(x);
for(int e= v+1;e<=dcur;e++){
d_rat_point y= coordinates.contents(S->vertices[e]);
point b= convert(y);

if(S->vertices[0]==anti_origin)
W.set_line_width(3);
else
W.set_line_width(1);
W.draw_segment(a,b);
}
}
}

d_rat_point x;

forall(x,coordinates){
point a= convert(x);
W.draw_point(a);
}
}

/*:45*//*46:*/
#line 55 "output_routines.w"

void Triangulation::print_all()
{
Simplex*S;

cout<<"\n dcur "<<dcur<<" origin_simplex: ";
if(origin_simplex!=nil)
cout<<origin_simplex->sim_nr;
else
cout<<"none";
cout<<" quasi_center: "<<quasi_center<<endl;
forall(S,all_simplices){
print(S);
}
}



/*:46*//*47:*/
#line 74 "output_routines.w"

void Triangulation::print(Simplex*S)
{
list_item p;

cout<<"\n["<<S->sim_nr<<"]-----------------------------------------------------\n";

for(int i= 0;i<=dcur;i++){
if(S->vertices[i]==anti_origin)
cout<<"[xx] anti-origin";
else
cout<<'['<<order_nr[S->vertices[i]]<<']'
<<coordinates.contents(S->vertices[i]);
cout<<" [";
if(S->neighbors[i])
cout<<S->neighbors[i]->sim_nr<<"] <-> ["<<S->opposite_vertices[i];
else
cout<<"*";
cout<<"] ";
if((S->vertices[0]!=anti_origin||i==0)&&dcur>0){
cout<<";  facet: "<<S->facets[i];
cout<<"; valid_equations: "<<S->valid_equations[i];
}
cout<<endl;
}
cout<<"Points: ";
forall(p,S->points)
cout<<'['<<order_nr[p]<<']'<<coordinates.contents(p)<<' ';
cout<<endl;
cout.flush();
}

/*:47*//*50:*/
#line 157 "output_routines.w"

void Triangulation::print_extremes(ostream&o)
{
Simplex*sim;
list_item p;
int i;
h_array<list_item,bool>printed(false);
list<list_item>points;

forall(sim,all_simplices)
if(sim->vertices[0]==anti_origin)
for(i= 1;i<=dcur;i++)
points.append(sim->vertices[i]);

o<<dmax<<endl<<points.size()<<endl;
forall(p,points)
{
if(!printed[p]){
for(i= 0;i<=dmax;i++)
o<<coordinates[p].ccoord(i);
o<<endl;
printed[p]= true;
}
}
}
#line 1 "pre_del.w"
/*:50*//*51:*/
#line 46 "pre_del.w"

void Triangulation::del(const d_rat_point&x)
{
dic_item dic_x;





if((dic_x= co_index.lookup(x))==nil)
return;

list_item item_x= co_index.inf(dic_x)->Pop();

if(co_index.inf(dic_x)->empty()){
delete co_index.inf(dic_x);
co_index.del_item(dic_x);
}

if(coordinates.length()==1)
{
/*52:*/
#line 85 "pre_del.w"

{
Simplex*sim;

forall(sim,all_simplices)
delete sim;
all_simplices.clear();
origin_simplex= nil;
coordinates.clear();
dcur= -1;
simplex= h_array<list_item,Simplex*>(nil);
position= h_array<list_item,list_item>(nil);
order_nr= h_array<list_item,int>(-1);
}

/*:52*/
#line 67 "pre_del.w"

return;
}

if((dcur==0)||(position[item_x]!=nil))
{
/*53:*/
#line 105 "pre_del.w"

{
Simplex*sim;

sim= simplex[item_x];
sim->points.del_item(position[item_x]);
position[item_x]= nil;
simplex[item_x]= nil;
order_nr[item_x]= -1;
coordinates.del_item(item_x);
}

/*:53*/
#line 73 "pre_del.w"

return;
}

/*54:*/
#line 171 "pre_del.w"

{
int is_dj= 0;
list<Simplex*>Sx;

h_array<Simplex*,int>facet(-1);
list<list_item>Rx;

list<list_item>Px;

/*55:*/
#line 233 "pre_del.w"

{
int i;
list_item p;
Simplex*sim,*neighbor;
h_array<list_item,bool>not_in_Rx(true);
h_array<list_item,bool>not_in_Px(true);

is_dj= collect_Sx(simplex[item_x],item_x,Sx,facet);
clear_visited_marks(simplex[item_x]);
forall(sim,Sx)
{
neighbor= sim->neighbors[facet[sim]];
p= neighbor->vertices[sim->opposite_vertices[facet[sim]]];


if((neighbor->vertices[0]!=anti_origin)&&(not_in_Px[p]==true)){
Px.append(neighbor->vertices[sim->opposite_vertices[facet[sim]]]);
not_in_Px[p]= false;
}

for(i= 0;i<=dcur;i++)
{
p= sim->vertices[i];
if((p!=anti_origin)&&(p!=item_x)&&(not_in_Rx[p]==true))
{
Rx.append(p);
not_in_Rx[p]= false;
}
}
forall(p,sim->points){
Rx.append(p);
}
}
sort(Rx);
}

/*:55*/
#line 181 "pre_del.w"


if((is_dj!=0)&&(dcur>0))
{
if(Px.empty()){
bool hulls_equal= true;
list_item p;

forall(p,Rx)
if(sees_facet(origin_simplex,facet[origin_simplex],
coordinates[p])!=0)
hulls_equal= false;
if(hulls_equal)
{
/*58:*/
#line 348 "pre_del.w"

{
Simplex*sim,*neighbor;
int j;

while(!Sx.empty())
{
sim= Sx.pop();
if(sim->vertices[0]!=anti_origin){
neighbor= sim->neighbors[facet[sim]];

all_simplices.del_item(neighbor->this_item);
delete neighbor;
}
for(j= facet[sim];j<dcur;j++)
{
sim->vertices[j]= sim->vertices[j+1];
sim->neighbors[j]= sim->neighbors[j+1];
sim->opposite_vertices[j]= sim->opposite_vertices[j+1];
}
for(j= 0;j<dcur;j++){

if(facet[sim->neighbors[j]]<sim->opposite_vertices[j])
sim->opposite_vertices[j]--;

sim->valid_equations[j]= -1;

simplex[sim->vertices[j]]= sim;
}

sim->vertices[dcur]= nil;
sim->opposite_vertices[dcur]= -1;
sim->neighbors[dcur]= nil;
sim->valid_equations[dcur]= -1;
}
dcur--;
quasi_center-= x;
position[item_x]= nil;
simplex[item_x]= nil;
order_nr[item_x]= -1;
coordinates.del_item(item_x);
}

/*:58*/
#line 195 "pre_del.w"

return;
}
}
/*59:*/
#line 421 "pre_del.w"

{
list_item new_dj;
list_item p;
int f,h;
Simplex*sim;
hyperplane v;

/*60:*/
#line 472 "pre_del.w"

{
list<list_item>possible_points;
list<list_item>h;

possible_points= Rx;
h= Px;
possible_points.conc(h);
sort(possible_points);


do{
new_dj= possible_points.pop();
}
while(sees_facet(origin_simplex,facet[origin_simplex],
coordinates[new_dj])==0);
}

/*:60*/
#line 429 "pre_del.w"

f= facet[origin_simplex];
p= origin_simplex->vertices[0];
origin_simplex->vertices[0]= item_x;
origin_simplex->vertices[f]= p;
sim= origin_simplex->neighbors[0];
origin_simplex->neighbors[0]= origin_simplex->neighbors[f];
origin_simplex->neighbors[f]= sim;
h= origin_simplex->opposite_vertices[0];
origin_simplex->opposite_vertices[0]= origin_simplex->opposite_vertices[f];
origin_simplex->opposite_vertices[f]= h;
v= origin_simplex->facets[0];
origin_simplex->facets[0]= origin_simplex->facets[f];
origin_simplex->facets[f]= v;
h= origin_simplex->valid_equations[0];
origin_simplex->valid_equations[0]= origin_simplex->valid_equations[f];
origin_simplex->valid_equations[f]= h;
facet[origin_simplex]= 0;
if(sees_facet(origin_simplex,facet[origin_simplex],
coordinates[new_dj])<0)

/*62:*/
#line 520 "pre_del.w"

{
Simplex*sim;

is_dj= 2;
sim= origin_simplex->neighbors[facet[origin_simplex]];
facet[sim]= origin_simplex->opposite_vertices[facet[origin_simplex]];
origin_simplex= sim;
}

#line 1 "deletion.w"
/*:62*/
#line 450 "pre_del.w"


quasi_center-= x;
quasi_center+= coordinates[new_dj];

order_nr[new_dj]= order_nr[item_x];

}

/*:59*/
#line 199 "pre_del.w"

}
/*63:*/
#line 79 "deletion.w"

{
h_array<Simplex*,list<int>*>visi_facet(nil);

list<Simplex*>newfacets;
h_array<Simplex*,list<int>*>xvisi_facet(nil);
list<Simplex*>vbfacets;
list<Simplex*>newsimplices;
list_item p;
Simplex*sim;

/*64:*/
#line 163 "deletion.w"

{
list_item s,n;
Simplex*sim,*neighbor;

s= Sx.first_item();
while(s!=nil)

{
n= Sx.next_item(s);
sim= Sx[s];
if((sim->vertices[0]==item_x)||
((is_dj==2)&&(sim->vertices[0]!=anti_origin)&&
(order_nr[sim->vertices[0]]<=
order_nr[origin_simplex->vertices[facet[origin_simplex]]])))

{
neighbor= sim->neighbors[facet[sim]];
if(visi_facet[neighbor]==nil){
visi_facet[neighbor]= new list<int>;
newfacets.append(neighbor);
}
visi_facet[neighbor]->append(sim->opposite_vertices[facet[sim]]);
neighbor->neighbors[sim->opposite_vertices[facet[sim]]]= nil;

all_simplices.del_item(sim->this_item);
delete sim;
Sx.del_item(s);
}
s= n;
}
}

/*:64*/
#line 90 "deletion.w"

Rx.append((list_item)anti_origin);
while(!Rx.empty())
{
p= Rx.pop();
if((order_nr[p]>=order_nr[item_x])||
(p==anti_origin)||
(position[p]!=nil))
{
if((position[p]==nil)||
(order_nr[p]>=order_nr[item_x]))
if(p!=anti_origin)
/*65:*/
#line 211 "deletion.w"

{
list_item f,n,l,m;
Simplex*sim;
int i;

f= newfacets.first_item();
while(f!=nil)
{
n= newfacets.next_item(f);
sim= newfacets[f];
l= visi_facet[sim]->first_item();
while(l!=nil)
{
m= visi_facet[sim]->next_item(l);
i= (*visi_facet[sim])[l];
if(sees_facet(sim,i,coordinates[p])<0)
{
if(xvisi_facet[sim]==nil)
{
xvisi_facet[sim]= new list<int>;
vbfacets.append(sim);
}
xvisi_facet[sim]->append(i);
visi_facet[sim]->del_item(l);
}
l= m;
}
if(visi_facet[sim]->empty())
{
delete visi_facet[sim];
visi_facet[sim]= nil;
newfacets.del_item(f);
}
f= n;
}
}

/*:65*/
#line 102 "deletion.w"

else
/*66:*/
#line 264 "deletion.w"

{
list_item s,n;
Simplex*sim,*neighbor;

vbfacets.conc(newfacets);
xvisi_facet= visi_facet;
s= Sx.first_item();
while(s!=nil){
n= Sx.next_item(s);
sim= Sx[s];
if(sim->vertices[0]!=anti_origin){
neighbor= sim->neighbors[facet[sim]];
if(xvisi_facet[neighbor]==nil){
xvisi_facet[neighbor]= new list<int>;
vbfacets.append(neighbor);
}
xvisi_facet[neighbor]->append(sim->opposite_vertices[facet[sim]]);
neighbor->neighbors[sim->opposite_vertices[facet[sim]]]= nil;
all_simplices.del_item(sim->this_item);
delete sim;
Sx.del_item(s);
}
s= n;
}
}

/*:66*/
#line 104 "deletion.w"
;
if(!vbfacets.empty())
/*67:*/
#line 301 "deletion.w"

{
Simplex*sim;
int f;

while(!vbfacets.empty())
{
sim= vbfacets.pop();
while(!xvisi_facet[sim]->empty())
{
f= xvisi_facet[sim]->pop();
/*68:*/
#line 337 "deletion.w"

{
int i,j;
Simplex*new_sim;

new_sim= new Simplex(dmax);
new_sim->vertices[0]= p;
new_sim->neighbors[0]= sim;
new_sim->opposite_vertices[0]= f;
sim->neighbors[new_sim->opposite_vertices[0]]= new_sim;
sim->opposite_vertices[new_sim->opposite_vertices[0]]= 0;
for(i= 0,j= 1;i<=dcur;i++)
if(i!=new_sim->opposite_vertices[0])
new_sim->vertices[j++]= sim->vertices[i];
/*69:*/
#line 382 "deletion.w"

{
int i;
array<bool>newf(0,dcur);


newf[0]= false;
for(i= 1;i<=dcur;i++)
{
newf[i]= true;
if(new_sim->vertices[0]!=anti_origin)
/*70:*/
#line 413 "deletion.w"

{
list_item s,n;
Simplex*sim;

s= Sx.first_item();
while(s!=nil)

{
n= Sx.next_item(s);
sim= Sx[s];
if(facets_equal(new_sim,i,sim,facet[sim]))
{
new_sim->neighbors[i]= sim->neighbors[facet[sim]];
new_sim->opposite_vertices[i]= sim->opposite_vertices[facet[sim]];
newf[i]= false;
all_simplices.del_item(sim->this_item);
delete sim;
Sx.del_item(s);
}
s= n;
}
}

/*:70*/
#line 393 "deletion.w"

else
/*71:*/
#line 457 "deletion.w"

{
int j;
Simplex*sim;

forall(sim,Sx)
{
for(j= 1;j<=dcur;j++)
if(facets_equal(new_sim,i,sim,j))
{
new_sim->neighbors[i]= sim->neighbors[j];
new_sim->opposite_vertices[i]= sim->opposite_vertices[j];
newf[i]= false;
}
}
}

/*:71*/
#line 395 "deletion.w"

if(newf[i]==true)
/*72:*/
#line 488 "deletion.w"

{
list_item s,n,l,m;
Simplex*sim;
int j;

s= newfacets.first_item();
while(s!=nil)
{
n= newfacets.next_item(s);
sim= newfacets[s];
l= visi_facet[sim]->first_item();
while(l!=nil)
{
m= visi_facet[sim]->next_item(l);
j= visi_facet[sim]->contents(l);
if(facets_equal(new_sim,i,sim,j))
{
new_sim->neighbors[i]= sim;
new_sim->opposite_vertices[i]= j;
newf[i]= false;
visi_facet[sim]->del_item(l);
}
l= m;
}
if(visi_facet[sim]->empty())
{
delete visi_facet[sim];
visi_facet[sim]= nil;
newfacets.del_item(s);
}
s= n;
}
}

/*:72*/
#line 397 "deletion.w"

}
/*73:*/
#line 532 "deletion.w"

{
int i;

for(i= 1;i<=dcur;i++)
if(newf[i]==true)
{
new_sim->neighbors[i]= nil;
if(visi_facet[new_sim]==nil)
{
visi_facet[new_sim]= new list<int>;
newfacets.append(new_sim);
}
visi_facet[new_sim]->append(i);
}
else
{
new_sim->neighbors[i]->neighbors[new_sim->opposite_vertices[i]]= new_sim;
new_sim->neighbors[i]->opposite_vertices[new_sim->opposite_vertices[i]]= i;
}
}

/*:73*/
#line 399 "deletion.w"

}

/*:69*/
#line 351 "deletion.w"

new_sim->this_item= all_simplices.append(new_sim);
newsimplices.append(new_sim);
}

/*:68*/
#line 312 "deletion.w"

}
delete xvisi_facet[sim];
xvisi_facet[sim]= nil;
}
}

/*:67*/
#line 106 "deletion.w"

else
if(p!=anti_origin)
/*74:*/
#line 573 "deletion.w"

{
bool in= false;
Simplex*sim;
int i;

if(position[p]!=nil){
newsimplices.init_iterator();
newsimplices.move_iterator(forward);
while((!in)&&(newsimplices.get_iterator()!=nil)){
in= true;
sim= newsimplices[newsimplices.get_iterator()];
if(sees_facet(sim,0,coordinates[p])<0)
in= false;
if(sim->vertices[0]!=anti_origin)

for(i= 1;(i<=dcur)&&(in==true);i++)
if(sees_facet(sim,i,coordinates[p])<0)

in= false;
newsimplices.move_iterator(forward);
}
if(in){
if(sim->vertices[0]==anti_origin)
sim= sim->neighbors[0];
position[p]= sim->points.append(p);
simplex[p]= sim;
}
else

Rx.append(p);
}
}

/*:74*/
#line 109 "deletion.w"

if((position[p]==nil)&&(p!=anti_origin))
/*75:*/
#line 613 "deletion.w"

{
list_item s,n;
Simplex*sim,*neighbor;

s= Sx.first_item();
while(s!=nil)
{
n= Sx.next_item(s);
sim= Sx[s];
if(sim->vertices[0]==p)
{
neighbor= sim->neighbors[facet[sim]];
if(visi_facet[neighbor]==nil){
visi_facet[neighbor]= new list<int>;
newfacets.append(neighbor);
}
visi_facet[neighbor]->append(sim->opposite_vertices[facet[sim]]);
neighbor->neighbors[sim->opposite_vertices[facet[sim]]]= nil;
all_simplices.del_item(sim->this_item);
delete sim;
Sx.del_item(s);
}
s= n;
}
}

/*:75*/
#line 111 "deletion.w"

}
}
/*76:*/
#line 644 "deletion.w"

{
if(is_dj==1){
origin_simplex= newsimplices.head();
}
}

/*:76*/
#line 114 "deletion.w"

/*77:*/
#line 664 "deletion.w"

{
Simplex*sim,*sim2;
int i;

forall(sim,newsimplices){
if(sim->vertices[0]!=anti_origin)
sim2= sim;
else
sim2= sim->neighbors[0];
for(i= 0;i<=dcur;i++){
simplex[sim2->vertices[i]]= sim2;
position[sim2->vertices[i]]= nil;
}
}
}

/*:77*/
#line 115 "deletion.w"

forall(sim,Sx)
{
all_simplices.del_item(sim->this_item);
delete sim;
}
simplex[item_x]= nil;
position[item_x]= nil;
order_nr[item_x]= -1;
coordinates.del_item(item_x);
}

/*:63*/
#line 201 "pre_del.w"

}

/*:54*/
#line 77 "pre_del.w"

}

/*:51*//*57:*/
#line 295 "pre_del.w"

int Triangulation::collect_Sx(Simplex*S,list_item item_x,
list<Simplex*>&Sx,h_array<Simplex*,int>&facet)
{
int i;
int is_dj= 0;

S->visited= true;
if(S==origin_simplex)
{
is_dj= 1;
Sx.push(S);
}
else
Sx.append(S);
for(i= 0;i<=dcur;i++){
if(S->vertices[i]==item_x)
facet[S]= i;
else
if(S->neighbors[i]->visited==false)
is_dj|= collect_Sx(S->neighbors[i],item_x,Sx,facet);
}
return is_dj;
}

/*:57*//*81:*/
#line 18 "support_functions.w"

vector Triangulation::make_vector(const d_rat_point&p)
{
int i;
vector v(p.dim());

for(i= 1;i<=p.dim();i++)
v[i-1]= p[i].todouble()/p[0].todouble();
return v;
}

d_rat_point Triangulation::find_closest_point(const d_rat_point&x)
{
double dist;
d_rat_point p(dmax),cp(dmax);
vector d(dmax);
dist= MAXDOUBLE;

forall(p,coordinates)
{
d= make_vector(p-x);
if(d.length()<dist)
{
dist= d.length();
cp= p;
}
}
return cp;
}

/*:81*//*83:*/
#line 76 "support_functions.w"

int Triangulation::sees_facet(Simplex*S,int f,const d_rat_point&x)
{
if(S->valid_equations[f]!=dcur)
compute_plane(S,f);
return which_side(S->facets[f],x);
}

void Triangulation::compute_plane(Simplex*S,int f)
{
if(S->valid_equations[f]!=dcur)
{
Simplex*NS;
int o;

NS= S->neighbors[f];
o= S->opposite_vertices[f];
if((NS!=nil)&&(NS->valid_equations[o]==dcur))
{
S->facets[f]= NS->facets[o].reverse();
}
else
{
int i,j;
array<d_rat_point>P(1,dcur);

j= 1;
for(i= 0;i<=dcur;i++)
if(i!=f)
P[j++]= coordinates[S->vertices[i]];
if(dcur==dmax){
if(S->vertices[f]==anti_origin)
S->facets[f]= hyperplane(P,quasi_center/(dcur+1),-1);
else
S->facets[f]= hyperplane(P,coordinates[S->vertices[f]],1);
}
else{
array<integer_vector>N(1,dcur);
d_rat_point p0;

if(S->vertices[f]==anti_origin)
p0= quasi_center/(dcur+1);
else
p0= coordinates[S->vertices[f]];
j= 1;
for(i= 0;i<=dcur;i++)
if(i!=f)
N[j++]= make_direction_from_point(coordinates[S->vertices[i]]-p0);
if(S->vertices[f]==anti_origin)
S->facets[f]= hyperplane(P,N,p0,-1);
else
S->facets[f]= hyperplane(P,N,p0,1);
}
}
S->valid_equations[f]= dcur;
}
}

/*:83*//*85:*/
#line 147 "support_functions.w"

bool Triangulation::is_dimension_jump(const d_rat_point&x)
{
array<d_rat_point>A(0,dcur);
int i;

for(i= 0;i<=dcur;i++)
A[i]= coordinates.contents(origin_simplex->vertices[i]);

return!is_contained_in_affine_hull(A,x);
}


/*:85*//*86:*/
#line 170 "support_functions.w"


bool Triangulation::member(const d_rat_point&x)
{
if(dcur==-1)
return false;
if(dcur<dmax)
if(is_dimension_jump(x))
return false;
find_visible_facets(x);
if(visible_simplices.empty())
return true;
visible_simplices.clear();
return false;
}


/*:86*//*88:*/
#line 204 "support_functions.w"

Triangulation*Triangulation::curr_tria;

int Triangulation::order_nof(const list_item&co)
{
return curr_tria->order_nr[co];
}

void Triangulation::sort(list<list_item>&L)
{
curr_tria= this;
L.bucket_sort(0,co_nr,order_nof);
}

/*:88*//*90:*/
#line 232 "support_functions.w"


bool Triangulation::facets_equal(Simplex*sim1,int facet1,Simplex*sim2,int facet2)
{
int i,j;

for(i= 0;i<=dcur;i++)
if(i!=facet1)
{
for(j= 0;j<=dcur;j++)
{
if(j==facet2)
continue;
if(sim1->vertices[i]==sim2->vertices[j])
break;
}
if(j==dcur+1)
return false;
}
return true;
}

/*:90*//*91:*/
#line 257 "support_functions.w"

list<d_rat_point>Triangulation::points()
{
return coordinates;
}

#line 1 "main.w"
/*:91*/
#line 21 "basics.w"

/*48:*/
#line 110 "output_routines.w"


ostream&operator<<(ostream&o,Triangulation&T)
{
d_rat_point v;
int i;

o<<T.dmax<<endl<<T.coordinates.size()<<endl;
forall(v,T.coordinates)
{
for(i= 0;i<=T.dmax;i++)
o<<v.ccoord(i);
o<<endl;
}
return o;
}

/*:48*//*49:*/
#line 131 "output_routines.w"


istream&operator>>(istream&i,Triangulation&T)
{
int dim;

i>>dim;
if(dim!=T.dmax)
error_handler(20,"chull: different dimensions in stream");
i>>dim;

d_rat_point v(dim);
while(!i.eof())
{
i>>v;
T.insert(v);
}
return i;
}

/*:49*/
#line 22 "basics.w"


/*:10*/
