/*9:*/
#line 11 "basics.w"

#ifndef CHULL_H
#define CHULL_H
/*12:*/
#line 34 "basics.w"

#include <LEDA/array.h>
#include <LEDA/list.h>
#include <LEDA/h_array.h>
#include <LEDA/integer.h>
#include <LEDA/vector.h>
#include <LEDA/dictionary.h>
#include <LEDA/stream.h>


/*:12*//*13:*/
#line 49 "basics.w"

#include <LEDA/window.h>
#include <LEDA/plane.h>

/*:13*//*14:*/
#line 61 "basics.w"

#include "d_rat_point.h"
#include "hyperplane.h"

/*:14*/
#line 14 "basics.w"

/*15:*/
#line 129 "basics.w"


class Simplex;

enum search_method{VISIBILITY,SEGMENT_WALK,MODIFIED_VISIBILITY};


class Triangulation{
private:

list<d_rat_point>coordinates;

dictionary<d_rat_point,list<list_item>*>co_index;

int co_nr;
h_array<list_item,int>order_nr;
h_array<list_item,Simplex*>simplex;
h_array<list_item,list_item>position;


int dcur;
int dmax;
Simplex*origin_simplex;
d_rat_point quasi_center;

list<Simplex*>all_simplices;

/*26:*/
#line 37 "search_methods.w"

void visibility_search(Simplex*S,const d_rat_point&x);
Simplex*search_to_outside(Simplex*S,const d_rat_point&x);
Simplex*segment_walk(const d_rat_point&x);
void collect_visible_simplices(Simplex*S,const d_rat_point&x);
void clear_visited_marks(Simplex*S);
void find_visible_facets(const d_rat_point&x);

list<Simplex*>visible_simplices;
Simplex*inner_simplex;

/*:26*//*34:*/
#line 406 "search_methods.w"

bool lambda_cmp(Simplex*S,const integer&Od,const integer&xd,
const integer&gx,const integer&gO,int g,
const integer&hx,const integer&hO,int h);
bool lambda_negative(Simplex*S,const integer&Od,const integer&xd,
const integer&nx,const integer&nO,int i);

/*:34*//*39:*/
#line 15 "dimension_jump.w"

void dimension_jump(Simplex*S,list_item x);

/*:39*//*56:*/
#line 280 "pre_del.w"

int collect_Sx(Simplex*S,list_item item_x,
list<Simplex*>&Sx,h_array<Simplex*,int>&facet);

/*:56*//*80:*/
#line 11 "support_functions.w"

vector make_vector(const d_rat_point&p);

/*:80*//*82:*/
#line 50 "support_functions.w"

int sees_facet(Simplex*S,int f,const d_rat_point&x);
void compute_plane(Simplex*S,int j);

/*:82*//*84:*/
#line 136 "support_functions.w"

bool is_dimension_jump(const d_rat_point&x);

/*:84*//*87:*/
#line 195 "support_functions.w"

static int order_nof(const list_item&co);
static Triangulation*curr_tria;
void sort(list<list_item>&L);

/*:87*//*89:*/
#line 220 "support_functions.w"

bool facets_equal(Simplex*sim1,int facet1,Simplex*sim2,int facet2);

/*:89*/
#line 156 "basics.w"


void print(Simplex*);

public:

search_method method;
int searched_simplices;
int created_simplices();


void insert(const d_rat_point&x);
bool member(const d_rat_point&x);
void del(const d_rat_point&x);
d_rat_point find_closest_point(const d_rat_point&x);
void show(window&W);
void print_all();
void print_extremes(ostream&o);
list<d_rat_point>points();
Triangulation(int d= 0,search_method m= SEGMENT_WALK);

~Triangulation();
Triangulation(Triangulation&T);

Triangulation&operator= (const Triangulation&T);

friend ostream&operator<<(ostream&,Triangulation&);
friend istream&operator>>(istream&,Triangulation&);
};

/*:15*/
#line 15 "basics.w"

#endif

/*:9*/
