@ sanity

@<Further mem...@>+=
bool sanity_check();
bool check_convexity();

@ function

@<Member functions of class Triangulation@>+=

#include <d_ray.h>

bool Triangulation::sanity_check()
{
Simplex* S;
int i,j,k;

#if 1
/* the vertices of a simplex are pairwise distinct */
forall(S,all_simplices){
   for(i = 0; i <=dcur; i++){
    for (j = i+1; j <= dcur;j++){
      if (S->vertices[i]==S->vertices[j])
	error_handler(1,"a simplex with two identical vertices");
     }
   }
}

/* Let |S| be any simplex and consider its |i|-th vertex and the simplex |T|
and vertex |v| opposite to it. Then |S| and |i| are opposite to |v|. Also 
the vertices of |T| different from |v| are the vertices of |S| different from
|i|.  */
forall(S,all_simplices){
 for(i = 0; i <=dcur; i++){
    Simplex* T = S->neighbors[i];
    if (T == nil)
     {
      printf("sim %d neighbor %d nil\n",S->sim_nr,i);
      print_all();
      exit(99);
     }
    int v = S->opposite_vertices[i];
    if (S != T->neighbors[v] || i != T->opposite_vertices[v]) {
        printf("sim %d facet %d\n",S->sim_nr,i);
        print_all();
      	error_handler(1,"error in neighbors or opposite");
    }

    for (j = 0; j <= dcur;j++){
	if (j != i){ // |j| must also occur as a vertex of |T|
	for (k = 0; k<=dcur && 
	( (S->vertices[j]!=T->vertices[k]) || k == v); k++); //no body
        if (k > dcur) error_handler(1,"too few shared vertices");
        }

    }
  }

 }

#endif

#if 1
if (dcur >= 1) check_convexity();
#endif


{
list_item p;
int i=0;
static int t=0;
Simplex *s1,*s2;
list_item i1,i2;

#if 1
forall_items(p, coordinates) {
i++;
if (((position[p] != nil) && (simplex[p]->points[position[p]] != p)) ||
    (order_nr[p] < 0) 
    ) {
cout<<order_nr[p]<<' '<<coordinates[p]; cout.flush();
printf(" position %08lx sim %d %d-ter punkt %d-ter aufruf\n",
   position[p],simplex[p]->sim_nr,i,t);
fflush(stdout);
print_all();
exit(99);
}
}
#endif
printf("%d.pkt\n",t);
#if 1
i1=all_simplices.first_item();
i2=all_simplices.next_item(i1);
while(i2!=nil) {
 s1=all_simplices[i1];
 s2=all_simplices[i2];
 if ((s1->vertices[0]==s2->vertices[0])&&(facets_equal(s1,0,s2,0)))
   { printf("%d und %d identisch\n",s1->sim_nr,s2->sim_nr);print_all(); exit(99);}
 i1=i2;
 i2=all_simplices.next_item(i1);
}
#endif
t++;
}
return true;
}

@ We define another procedure to check the validity of our data structure. We
check whether the surface defined by our data structure is convex. To this
end we do two things. 
\begin{itemize}
\item We check whether the center of the origin simplex is inside the current
hull, i.e., whether all hull facets declare the origin simplex inside. Assume
this is the case (it would be a surprise if it were not because we use the
center to normalize the hyperplane equations of all hull facets).

\item We check whether every ridge is locally convex.

\item We shoot a ray from the center of the origin simplex to the center of
some hull facet. If this ray intersects the closure of any other facet then 
the surface is clearly not convex. If it misses then all then the surface is
convex.
\end{itemize}

@<Member functions of class Triangulation@>+=

bool Triangulation::check_convexity()
{

bool result = true;

/* recall that |quasi_center| is the sum of the vertices of the origin simplex.
Dividing by |dcur + 1| gives us the center of the origin simplex. We check 
whether it is locally inside with respect to all hull facets.
*/

d_rat_point center = quasi_center/(dcur+1);
Simplex* S;

#if 1
forall(S, all_simplices)
  { 
    if ((S->vertices[0]==nil) && 
  	        sees_facet(S,0,center) >= 0)

{
#if 1
       printf("sim %d\n",S->sim_nr);
       print_all();
       error_handler(1,"center on wrong side of a hull facet"); 
#endif
}
    if (S->vertices[0] != anti_origin) {
#if 1
      d_rat_point center_of_simplex(dmax);
      int i;
      for (i=0; i<=dcur;i++)
	center_of_simplex += coordinates[S->vertices[i]];
      center_of_simplex =center_of_simplex / (dcur+1);
      for (i=0; i<= dcur; i++) 
	if (sees_facet(S,i,center_of_simplex) <= 0) {
#if 1
	  print_all();
	  printf("sim %d facet %d\n",S->sim_nr,i);
	  cout <<"center "<<center_of_simplex<<endl;cout.flush();
	  error_handler(1,"center point not in simplex");
#endif
	}
#endif
    }
  }
#endif

/* next we check convexity at every ridge. Let |S| be any hull simplex and
let |v| be any vertex of its base facet. The vertex opposite to |v| must not
be on the positive side of the base facet.*/

#if 1
forall(S, all_simplices)
  { compute_plane(S,0);
    if ((S->vertices[0]==anti_origin))
	{for (int i = 1; i <= dcur; i++)
	   {int k = S->opposite_vertices[i];
            if (which_side(S->facets[0],coordinates[S->neighbors[i]->vertices[k]]) > 0)
		{ error_handler(1,"detected local non-convexity"); }
           }
        }
  }
#endif

#if 1
/* next we select one hull facet */

Simplex* selected_hull_simplex;
forall(S, all_simplices)
  { if ((S->vertices[0]==anti_origin))
	{selected_hull_simplex = S; break;}
  }



/* we compute the center of gravity of the base facet of the hull simplex */

d_rat_point center_of_hull_facet(dmax);
for (int i = 1; i <= dcur; i++) 
  {center_of_hull_facet += coordinates[selected_hull_simplex->vertices[i]];}
center_of_hull_facet = center_of_hull_facet/dcur;

/* we set up the ray from the center to the center of the hull facet */

d_ray l(center,center_of_hull_facet);

/* and check whether it intersects the interior of any hull facet */

forall(S, all_simplices)
  { if ((S->vertices[0]==anti_origin)  && S != selected_hull_simplex)
	{ d_rat_point p;
          if ( intersection(S->facets[0],l,p) )
          {array<d_rat_point> A(dcur);
           for (int i = 0; i < dcur; i++) @+{@+A[i] = coordinates[S->vertices[i+1]];@+}
           if (is_contained_in_simplex(A,p))
            error_handler(1,"current hull has double coverage");
          }
        }
  }

#endif
return true;
}


