\manpage {matrix} {}  {Real-Valued Matrices} 
 
\definition
An instance of the data type $matrix$ is a matrix of number variables.  

 
\creation M 
 
\create {(int\ n=0,\ int\ m=0)}
   { creates an instance $M$ of type $matrix$, $M$ is initialized to
           the $n \times m$ - zero matrix.  }
 
 
\operations 2 4 
 
\op  int     dim1 {()}
           {  returns $n$, the number of rows of $M$.  }
 
 
\op  int     dim2 {()}
           {  returns $m$, the number of columns of $M$.  }
 
 
\op  vector\& row {(int\ i)}
           {  returns the $i$-th row of $M$ (an $m$-vector).
	 \precond  $0 \le i \le n-1$.  }
 
 
\op  vector col {(int\ i)}
           {  returns the $i$-th column of $M$ (an $n$-vector).
	 \precond  $0 \le i \le m-1$.  }
 
 
\funop number\&  {int\ i, \ int\ j}
         {  returns $M_{i,j}$. \\
	  \precond $0\le i\le n-1$ and $0\le j\le m-1$. }
 
 
\binop matrix + {M1}
         {  Addition. \\
 	   \precond $M$.dim1() = $M1$.dim1() and $M$.dim2() = $M1$.dim2(). }
 
 
\binop matrix - {M1}
         {  Subtraction. \\
	   \precond $M$.dim1() = $M1$.dim1() and
	   $M$.dim2() = $M1$.dim2(). }
 
 
\binop matrix * {M1}
         {  Multiplication. \\
	   \precond $M$.dim2() = $M1$.dim1(). }
 
 
\binop vector * { vector\ vec}
         {  Multiplication with vector.\\
	    \precond $M$.dim2() = $vec$.dim().  }
 
 
\binop matrix * {number\ x}
         {  Multiplication with number x. }
 
 
\func  matrix trans {( matrix\ M)}
           {  returns $M^T$ ($m\times n$ - matrix).  }
 
 
\func  matrix inv {( matrix\ M, \ number\ \&\ D)}
           {  returns the inverse matrix of $M$. More precisely, $1/D$ times the
matrix returned is the inverse of $M$.\\
	 \precond  $M$.det() $\neq$ 0.  }
 
 
\func  number det {( matrix\ M)}
           {  returns the determinant of $M$.\\
	 \precond  $M$ is quadratic.  }
 
 
\func  number det {( matrix\ M, \ matrix\ \&\ L, \ matrix\ \&\ U)}
           {  returns the determinant and a LU-decomposition of $M$, more precisely, $L$ and $U$ are lower and upper diagonal matrices respectively, and if all entries of the $i-th$ column of $U$ are interpreted a rational numbers
with denominator $U(i-1,i-1)$ then $M = L \cdot U$. All diagonal entries of
$L$ are 1 and hence the determinant of $M$ is equal to $U(n-1,n-1)$.  \\
	 \precond  $M$ is quadratic.  }
 
 
\func  bool linear\_solver {( matrix\ \&\ M, \  vector\ b, \ vector\ \&x, \ number\ \&\ D, \ vector\ \&\ c)}
           {  determines whether the linear system $M\cdot x = b$ is solvable. If
yes, then $(1/D) x$ is a solution, if not then $c^T \cdot M = 0$ and $c^T \cdot b \not= 0$.\\
	 \precond $M$.dim1() = $b$.dim().  }
 
 
\func  bool linear\_solver {( matrix\ \&\ M, \  vector\ b, \ vector\ \&x, \ number\ \&\ D)}
           {  as above, but without the witness $c \\
	 \precond $M$.dim1() = $b$.dim().  }
 
 
\func  bool linear\_solver {( matrix\ \&\ M, \  vector\ b, \ vector\ \&x, \ number\ \&\ D, \ matrix\ \&\ spanning\_vectors, \ vector\ \&\ c)}
           {  determines the complete solution space of the linear system $M\cdot x = b$. If the system is unsolvable then $c^T \cdot M = 0$ and $c^T \cdot b \not= 0$. If the system is solvable then $(1/D) x$ is a solution, and the columns of
|spanning_vectors| are a maximal set of linearly independent solutions to the
corresponding homogeneous system.\\
	 \precond $M$.dim1() = $b$.dim().  }
 
 
\func  bool homogeneous\_linear\_solver {( matrix\ \&\ M, \ vector\ \&x)}
           {  determines whether the homogeneous linear system $M\cdot x = 0$ has a non-trivial solution. If
yes, then $x$ is such a solution. }
 
 
\func  int rank {( matrix\ \&\ M)}
           {  determines rank of the matrix $M$ }
 
 
\binopfunc  ostream\&   {ostream\&\ O\ <<M}
           {  writes matrix $M$ row by row to the output stream $O$.  }
 
 
\binopfunc  istream\&   {istream\&\ I\ >>\&\ M}
           {  reads matrix $M$ row by row from the input stream $I$.  }
 
 
\implementation
Data type $matrix$ is implemented by two-dimensional arrays of numbers. 
Operations det, solve, and inv take time $O(n^3)$, dim1, dim2, row, and col 
take constant time, all other operations take time $O(nm)$.  
The space requirement is $O(nm)$.
 
