
/* This file has been automatically generated from "hyperplane.w"
   by CTANGLE (Version 3.1 [km2c]) */
/*1:*/
#line 10 "hyperplane.w"

#line 11 "hyperplane.w"
#include "numberdef"
#include "hyperplane.h"
#include "integer_matrix.h"
#include <LEDA/integer.h>

/*2:*/
#line 54 "hyperplane.w"


hyperplane_rep::hyperplane_rep(const array<d_rat_point>&P,
const array<integer_vector>&N,const d_rat_point&o,int side)
{
int d= o.dim();
int p= P.high()-P.low()+1;
int plow= P.low();
int n= N.high()-N.low()+1;
int nlow= N.low();
int i,j;

dim= d;
coefficients= new number[dim+1];
for(i= 0;i<p;i++)
if(P[plow+i].dim()!=d)
error_handler(1,"hyperplane::constructor: P-dim does not fit");
for(i= 0;i<n;i++)
if(N[nlow+i].dim()!=d)
error_handler(1,"hyperplane::constructor: N-dim does not fit");

integer_matrix A(int(p+d),int(d+1+n));




for(i= 0;i<p;i++)
for(j= 0;j<=d;j++)
A(i,j)= P[i+plow][j];


for(i= 0;i<d;i++)
{
A(p+i,1+i)= 1;
for(j= 0;j<n;j++)
A(p+i,d+1+j)= N[nlow+j][i];
}

integer_vector non_triv_sol;
homogeneous_linear_solver(A,non_triv_sol);
number sum= 0;

for(i= 0;i<=d;i++)
sum+= non_triv_sol[i]*o[i];
if(sum==0)
error_handler(1,"cannot use o to determine side");
int o_side= sign(sum)*sign(o[0]);
if(side!=o_side)
for(i= 0;i<=d;i++)
coefficients[i]= -non_triv_sol[i];
else
for(i= 0;i<=d;i++)
coefficients[i]= non_triv_sol[i];
}


/*:2*//*3:*/
#line 116 "hyperplane.w"


hyperplane_rep::hyperplane_rep(const array<d_rat_point>&P,
const d_rat_point&o,int side)

{
int d= dim= o.dim();
if(d!=P.high()-P.low()+1)
error_handler(1,"hyperplane-constructor: P has wrong number of points");
coefficients= new number[d+1];

int plow= P.low();
integer_matrix A(d,d+1);

int i,j,k;
for(i= 0;i<d;i++)
{
for(j= 0;j<=d;j++)A(i,j)= P[plow+i][j];
}

integer_vector non_triv_sol;
homogeneous_linear_solver(A,non_triv_sol);

number sum= 0;
for(i= 0;i<=d;i++)sum+= non_triv_sol[i]*o[i];
if(sum==0)error_handler(1,"cannot use o to determine side");

int o_side= (sum>0?1:-1)*(o[0]>0?1:-1);
if(side!=o_side)
{for(i= 0;i<=d;i++)coefficients[i]= -non_triv_sol[i];}
else{for(i= 0;i<=d;i++)coefficients[i]= non_triv_sol[i];}


}
/*:3*//*4:*/
#line 164 "hyperplane.w"


integer_vector hyperplane::equation()const
{integer_vector result(ptr()->dim+1);
for(int i= 0;i<=ptr()->dim;i++){result[i]= ptr()->coefficients[i];}
return result;
}

integer_vector hyperplane::normal()const
{integer_vector result(ptr()->dim);
for(int i= 0;i<ptr()->dim;i++){result[i]= ptr()->coefficients[i+1];}
return result;

}

number hyperplane::value_at(d_rat_point p)const
{if(dim()!=p.dim())error_handler(1,"hyperplane::value_at: dimensions do not agree");
number result= 0;
for(int i= 0;i<=dim();i++)
{result+= ptr()->coefficients[i]*p[i];}
return result;
}

/*:4*//*5:*/
#line 192 "hyperplane.w"

int which_side(const hyperplane&h,const d_rat_point&x)
{number Sum= 0;
if(h.dim()!=x.dim())error_handler(1,"hyperplane:which side incompatible dimension");
for(int i= 0;i<=h.dim();i++)Sum+= h[i]*x[i];
if(Sum==0)return 0;
return((Sum>0?1:-1)*(x[0]>0?1:-1));
}

ostream&operator<<(ostream&out,const hyperplane&h)
{out<<"(";
for(int i= 0;i<=h.dim();i++)cout<<h[i]<<(i<h.dim()?",":"");
out<<")";
return out;
}


istream&operator>>(istream&in,hyperplane&h)
{cout<<"not implemented yet";
return in;
}

int compare_help(const hyperplane&p,const hyperplane&q)
{error_handler(1,"not implemented");return 1;}


/*:5*/
#line 16 "hyperplane.w"




/*:1*/
